	REM
	REM Calculate digits of Pi
	REM by Oscar Toledo G. http://nanochess.org/
	REM Creation date: 3/14/16 (Mar/14/2016)
        REM Revision date: 3/14/24 (Mar/14/2024) for CVBasic.

	REM Based on http://www.codecodex.com/wiki/Calculate_digits_of_pi#C

	CONST scale = 100
	CONST arrinit = 20
	CONST #digits = 250	' It will generate 250/14*2 digits
				' Cannot be greater because arr is 8-bit
	DIM arr(#digits + 1)

	carry = 0
	FOR #i = 0 TO #digits
		arr(#i) = arrinit
	NEXT #i

	PRINT AT 0,"Digits of PI"
        PRINT AT 72,""
	#i = #digits
	WHILE 1
		#sum = 0
		FOR j = #i TO 1 STEP -1
			#sum = #sum * j + scale * arr(j)
			arr(j) = #sum % (j * 2 - 1)
			#sum = #sum / (j * 2 - 1)
		NEXT j
		k = carry + #sum / scale
		PRINT k / 10
		IF #i = #digits THEN PRINT "."
		PRINT k % 10
		carry = #sum % scale
		IF #i < 14 THEN EXIT WHILE
		#i = #i - 14
	WEND

	WHILE 1
	WEND
